
$(function () {
	$.validator.setDefaults({
		submitHandler: function (form) {
			form.submit();
		}
	});
	$('#js-membership-form').validate({
		rules: {
			member: {
				required: true
			},
			valid_from: {
				required: true
			},
			type: {
				required: true
			},
		},
		messages: {
			member: "Please select member",
			type: "Please select membership type",
			valid_from: "Please select a date",
		},
		errorElement: 'span',
		errorPlacement: function (error, element) {
			error.addClass('invalid-feedback');
			element.closest('.form-group').append(error);
		},
		highlight: function (element, errorClass, validClass) {
			$(element).addClass('is-invalid');
		},
		unhighlight: function (element, errorClass, validClass) {
			$(element).removeClass('is-invalid');
		}
	});
});
